package row_data_gateway;
import db_context.DbContext;

import java.sql.*;

public class Segment {
    private Integer id;
    private Integer transport_id;
    private Integer connection_id;
    private boolean accident;
    private Integer damage = 0;
    private Timestamp time;

    public Integer getId() { return id; }
    public void setId(Integer id) { this.id = id; }

    public Integer getTransport_id() { return transport_id; }
    public void setTransport_id(Integer transport_id) { this.transport_id = transport_id; }

    public Integer getConnection_id() { return connection_id; }
    public void setConnection_id(Integer connection_id) { this.connection_id = connection_id; }

    public boolean getAccident() { return this.accident; }
    public void setAccident(boolean accident) { this.accident = accident; }
    public void setAccident(String accident){
        if(accident.equals("Yes") || accident.equals("yes") || accident.equals("y")){
            this.accident = true;
        }
    }

    public Integer getDamage() { return damage; }
    public void setDamage(Integer damage) { this.damage = damage; }

    public Timestamp getTime() { return time; }
    public void setTime(Timestamp time) { this.time = time; }

    public void insert() throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("INSERT INTO segments (transport_id, connection_id, accident, damage, time) VALUES (?,?,?,?,?)", Statement.RETURN_GENERATED_KEYS)) {
            s.setInt(1, transport_id);
            s.setInt(2, connection_id);
            s.setBoolean(3, accident);
            s.setInt(4, damage);
            s.setTimestamp(5, time);
            s.executeUpdate();

            try (ResultSet r = s.getGeneratedKeys()) {
                r.next();
                id = r.getInt(1);
            }
        }
    }

    public void update() throws SQLException {
        if (id == null) {
            throw new IllegalStateException("id is not set");
        }

        try (PreparedStatement s = DbContext.getConnection().prepareStatement("UPDATE segments SET transport_id = ?, connection_id = ?, accident = ?, damage = ?, time = ? WHERE id = ?")) {
            s.setInt(1, transport_id);
            s.setInt(2, connection_id);
            s.setBoolean(3, accident);
            s.setInt(4, damage);
            s.setTimestamp(5, time);
            s.setInt(6, id);
            s.executeUpdate();
        }
    }

    public void delete() throws SQLException {
        if (id == null) {
            throw new IllegalStateException("id is not set");
        }

        try (PreparedStatement s = DbContext.getConnection().prepareStatement("DELETE FROM segments WHERE id = ?")) {
            s.setInt(1, id);
            s.executeUpdate();
        }
    }
}